// sicherstellen, dass alle HTML-ELemente da sind
document.addEventListener("DOMContentLoaded", function(){

	/**
	 * D3 BEISPIEL: 3 KLEINE KREISE
     * http://bost.ocks.org/mike/circles/
	 **/

	// whle alle "circle" Elemente
	// jQuery quivalent: $("circle")
	var circle = d3.selectAll("circle");

	// flle alle kreise mit der Farbe "steelblue"
	circle.style("fill", "steelblue");
	
	// setze den Radius auf 30px
	circle.attr("r", 30);

	// Random liefert einen zuflligen Wert zwischen 0 und 1
	// cx ist die x-Position von link aus gesehen
	circle.attr("cx", function() { 
		return Math.random() * 1024; 
	});

	// Binde eine Zahl an jeden Kreis 
	// 1. Kreis = 32 ...
	circle.data([16, 256, 1024]);
	
	// Das Attribut r (Radius) wird mit der Wurzel (sqrt) der an ihn gebundenen Zahl gefllt
	// 1. Kreis Radius = sqrt(16) = 4
	circle.attr("r", function(d) { 
		return Math.sqrt(d); 
	});
	
	// Das Attribut cy (y-Position) wird auf den Index des Elements gesetzt
	// i fngt bei 0 an
	// i. Kreis cy = i + 1
	// 1. Kreis cy = 0 + 1 = 1
	circle.attr("cy", function(d, i) { 
		return (i+1)*30; 
	});	

	/**
	 * ENTER LIST
	 **/
	// hole das <svg>-Element
	var svg = d3.select("svg");
	
	// nimm alle <circle>-Elemente und bindfolgende Zahlen daran (Siehe Zeile 21)
	// ACHTUNG: 4 Zahlen, aber nur 3 Kreise
	var circle = svg.selectAll("circle").data([16, 256, 1024, 2048]);
	
	// Die letzte Zahl landet erst einmal in der "Enter" Liste
	// Mit enter() wird ber alle Elemente der "Enter" Liste iteriert
	// append("circle") fgt fr jedes Element einen neuen Kreis hinzu
	var enterList = circle.enter().append("circle");	
	console.log(enterList);

	// Setze fr jedes Element die schon bekannten Attribute cy, cx und r
	enterList.attr({
		"cy": function(d, i) { return (i+1)*30; },
		"cx": function() { return Math.random() * 1024; },
		"r": function(d) { return Math.sqrt(d); }
	});
	
	/**
	 * EXIT LIST
	 **/
	// nimm alle <circle>-Elemente und binde folgende Zahlen daran (Siehe Zeile 21)
	// ACHTUNG: 4 Kreise, aber nur 2 Zahlen
	circle = circle.data([16, 256]);
	
	// Alle Kreise fr die es keine Zahlen gibt, landen in der "Exit" Liste
	var exitList = circle.exit();
	console.log(exitList);
	
	// Elemente der "Exit" Liste lschen
	exitList.remove();
	
	/**
	 * GARNICHT SO SCHWER, ODER?
	 *
	 * Hier hast du Kekse und Milch
	 *
	 * 	                              .-'''''-.
	 *                                |'-----'|
	 *                                |-.....-|
	 *                                |       |
	 *                                |       |
	 *               _,._             |       |
	 *          __.o`   o`"-.         |       |
	 *       .-O o `"-.o   O )_,._    |       |
	 *      ( o   O  o )--.-"`O   o"-.`'-----'`
	 *       '--------'  (   o  O    o)  
 	 *                    `----------`
	 * 
	 **/
	
}, false);